/*
** INI(INF) file treating interfaces
**
** Writen by Sakae Tatibana <tatibana@extra.hu>
**
** 2000, 7/3 coding start
*/

#ifndef INI_H
#define INI_H

#include <string.h>
#include <ctype.h>

#ifdef __cplusplus
extern "C" {
#endif
	
typedef struct {
	char *key;
	char *value;
} INI_ELEMENT;

typedef struct {
	char *label;
	int num_of_elements;
	INI_ELEMENT *elements;
} INI_SECTION;

typedef struct {
	char *path;
	int num_of_sections;
	INI_SECTION *sections;
} INI;

#ifndef INI_C
extern int open_ini_file(char *path, INI *out);
extern int close_ini_file(INI *p);
extern char *get_ini_element_value(INI *p, char *section, char *key);
extern char *read_ini_element_value(INI *p, char *section, char *key);
#endif

#ifdef __cplusplus
}
#endif

#endif